local dragonMageddon={}
local dragonImage
local SCALE=1.5
local dragonX,dragonY=640*SCALE,360*SCALE
local dragonOriginalWidth,dragonOriginalHeight=2078,144
local dragonTargetWidth,dragonTargetHeight=1802,125
local dragonCurrentWidth,dragonCurrentHeight=dragonOriginalWidth*2*SCALE,dragonOriginalHeight*2*SCALE
local dragonOpacity=0
local dragonVisible=false
local explosionActive=false
local quads={}
local imageWidth,imageHeight
local centerX,centerY
local possibleSizes={4,5,6,7,8,9}
math.randomseed(os.time())
function dragonMageddon.load()
dragonImage=love.graphics.newImage("dragonmageddon.png")
imageWidth,imageHeight=dragonImage:getDimensions()
centerX,centerY=imageWidth/2,imageHeight/2
local y=0
while y<imageHeight do
local rowSize=possibleSizes[math.random(1,#possibleSizes)]
if y+rowSize>imageHeight then
rowSize=imageHeight-y
if rowSize<=0 then break end
end
local x=0
while x<imageWidth do
local size=rowSize
if x+size>imageWidth then
size=imageWidth-x
if size<=0 then break end
end
local qd=love.graphics.newQuad(x,y,size,size,imageWidth,imageHeight)
table.insert(quads,{quad=qd,sx=x,sy=y,size=size,x=0,y=0,screenW=0,screenH=0,vx=0,vy=0,active=false})
x=x+size
end
y=y+rowSize
end end
function dragonMageddon.update(dt,timePassed)
if timePassed>=2 and timePassed<6 and not explosionActive then
if not dragonVisible then
dragonVisible=true
dragonCurrentWidth=dragonOriginalWidth*2*SCALE
dragonCurrentHeight=dragonOriginalHeight*2*SCALE
dragonOpacity=0
end
local baseW=dragonOriginalWidth*2*SCALE
local baseH=dragonOriginalHeight*2*SCALE
local t=(timePassed-2)/4
if t>1 then t=1 end
dragonCurrentWidth=baseW+(dragonTargetWidth-baseW)*t
dragonCurrentHeight=baseH+(dragonTargetHeight-baseH)*t
dragonOpacity=t
elseif timePassed>=9.6 and not explosionActive then
explosionActive=true
dragonVisible=true
local scaleX=dragonCurrentWidth/imageWidth
local scaleY=dragonCurrentHeight/imageHeight
local baseX=dragonX-dragonCurrentWidth/2
local baseY=dragonY-dragonCurrentHeight/2
for _,q in ipairs(quads) do
q.x=baseX+q.sx*scaleX
q.y=baseY+q.sy*scaleY
q.screenW=q.size*scaleX
q.screenH=q.size*scaleY
local angle=math.random()*2*math.pi
local speed=math.random(300,1000)*SCALE
q.vx=math.cos(angle)*speed
q.vy=math.sin(angle)*speed
q.active=true
end end
if explosionActive then
local allOffScreen=true
local winW,winH=love.graphics.getWidth(),love.graphics.getHeight()
for _,q in ipairs(quads) do
if q.active then
q.x=q.x+q.vx*dt
q.y=q.y+q.vy*dt
if (q.x+q.screenW>0) and (q.x<winW) and (q.y+q.screenH>0) and (q.y<winH) then
allOffScreen=false
else
q.active=false
end end end
if allOffScreen then
dragonVisible=false
end end end
function dragonMageddon.draw()
if not dragonVisible then return end
if not explosionActive then
love.graphics.setColor(1,1,1,dragonOpacity)
love.graphics.draw(dragonImage,dragonX-dragonCurrentWidth/2,dragonY-dragonCurrentHeight/2,0,dragonCurrentWidth/dragonOriginalWidth,dragonCurrentHeight/dragonOriginalHeight)
love.graphics.setColor(1,1,1,1)
else
love.graphics.setColor(1,1,1,1)
local scaleX=dragonCurrentWidth/imageWidth
local scaleY=dragonCurrentHeight/imageHeight
for _,q in ipairs(quads) do
love.graphics.draw(dragonImage,q.quad,q.x,q.y,0,scaleX,scaleY)
end end end
return dragonMageddon
